 ; Ŀ
 ;   Poxx - invariable box pattern routine.                                
 ;   Copyright 1993  Rocket Software                                       
 ;   Remember just how bored you were in school?                           
 ; 

 ; Ŀ
 ;   Subroutine Cruns: returns the coordinates of the corners of the       
 ;   current display area.                                                 
 ; 
 (DEFUN CRUNS ( / ra a vs ctr w maxx minx maxy miny aa bb cc dd)
  (setq a (getvar "screensize"))           ; view height & width (pixels)
  (setq a (/ (car a) (cadr a)))            ; view width/height ratio
  (setq vs (* (getvar "viewsize") 0.5))    ; view height in drawing units
  (setq ctr (getvar "viewctr"))            ; centre point of screen
  (setq w (* vs a ))                       ; view half width
  (setq maxx (+ (car ctr) w))
  (setq minx (- (car ctr) w))
  (setq maxy (+ (cadr ctr) vs))
  (setq miny (- (cadr ctr) vs))
  (setq ll (list minx miny))
  (setq ul (list minx maxy))
  (setq ur (list maxx maxy))
  (setq lr (list maxx miny))
;  (grdraw ll ul 7 1)
;  (grdraw ul ur 7 1)
;  (grdraw ur lr 7 1)
;  (grdraw lr ll 7 1)
 (list ll ul ur lr))
 ; Ŀ
 ;   Cruns end.                                                            
 ; 

 ; Ŀ
 ;   Poxx.                                                                 
 ; 
 (defun c:poxx ( / colo aa bb cc dd numm nump linsp)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setvar "blipmode" 0)
  (setq colo 1)
  (if (setq aa (getpoint "First corner or <Return> for screen: "))
      (setq cc (getcorner aa " Other corner:\n"))
      (progn
           (setq corner (cruns))
           (setq aa (car corner))
           (setq cc (caddr corner))))
  (if (/= (type num) 'INT) (setq num 125))
  (setq numm num)
  (setq num (getint (strcat "\nNumber of cycles <" (itoa num) ">: ")))
  (if (null num) (setq num numm))
  (if (/= (type numdiv) 'INT) (setq numdiv 20))
  (setq nump (getint (strcat "\nDivisions per side <" (itoa numdiv) ">: ")))
  (if nump (setq numdiv nump))
  (initget 0 "Real Phantom")
  (Setq linsp (getkword (strcat "Real or <Phantom> lines? ")))
  (if (or (null linsp) (= linsp "Phantom"))
      (setq linsp ())
      (setq linsp T))
  (setq bb (cons (car cc) (cdr aa)))
  (setq dd (cons (car aa) (cdr cc)))
  (if linsp
      (command "line" aa bb cc dd aa "")
      (progn
           (grdraw aa bb colo)
           (grdraw bb cc colo)
           (grdraw cc dd colo)
           (grdraw dd aa colo)))
  (repeat num
       (setq cc (polar cc (angle cc dd) (/ (distance cc dd) numdiv)))
       (if linsp
           (command "line" bb cc "")
           (grdraw bb cc colo))
       (setq dd (polar dd (angle dd aa) (/ (distance dd aa) numdiv)))
       (if linsp
           (command "line" cc dd "")
           (grdraw cc dd colo))
       (setq aa (polar aa (angle aa bb) (/ (distance aa bb) numdiv)))
       (if linsp
           (command "line" dd aa "")
           (grdraw dd aa colo))
       (setq bb (polar bb (angle bb cc) (/ (distance bb cc) numdiv)))
       (if linsp
           (command "line" aa bb "")
           (grdraw aa bb colo)))
 (princ))